# 画面設計書 5-Simple Ticker 2 (Callback版)

## 概要

本ドキュメントは、VBCorLibプロジェクトのサンプルアプリケーション「Simple Ticker 2 (Callback版)」の画面設計書です。

### 本画面の処理概要

Simple Ticker 2 (Callback版)は、VBCorLibライブラリが提供するTickerオブジェクトのコールバック通知機能をデモンストレーションする画面です。No.3「Simple Ticker (Event版)」とは異なり、WithEventsによるイベント受信ではなく、AddressOfで指定したコールバック関数を使用してタイマー通知を受け取る方式を示しています。

**業務上の目的・背景**：VB6/VBAでイベント駆動型の処理を実装する場合、WithEventsキーワードを使用する方法と、コールバック関数を使用する方法があります。コールバック方式は、モジュールレベルの関数を直接呼び出すため、オブジェクト指向的なイベントハンドリングとは異なるアプローチが可能です。本画面は、両方式の違いを開発者に示し、適切な選択ができるよう支援することを目的としています。

**画面へのアクセス方法**：Examples/Misc/SimpleTicker2/SimpleTicker2.vbpプロジェクトを開き、F5キーで実行することでこの画面が表示されます。

**主要な操作・処理内容**：
1. Delayテキストボックスにインターバル（ミリ秒）を入力
2. 「Start Ticker」ボタンでタイマー開始
3. 「Stop Ticker」ボタンでタイマー停止
4. 「Reset Count」ボタンでカウンターリセット
5. コールバック関数（TickerCallback）が発火ごとに呼び出されカウンター加算

**画面遷移**：本画面は独立したデモアプリケーションであり、他の画面への遷移はありません。

**権限による表示制御**：本画面は開発者向けデモツールであり、特別な権限制御は実装されていません。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 93 | Ticker | 主機能 | Tickerオブジェクトのコールバック通知機能デモ（タイマー開始、停止、インターバル設定、コールバック関数呼び出し） |

## 画面種別

デモンストレーション / タイマー制御

## URL/ルーティング

VB6デスクトップアプリケーションのため、URLルーティングは存在しません。フォームファイル: `Examples/Misc/SimpleTicker2/Form1.frm`

## 入出力項目

| 項目名 | コントロール | 項目種別 | データ型 | 説明 |
|--------|-------------|----------|----------|------|
| Text1 | TextBox | 入力 | String | インターバル（ミリ秒）。初期値100 |
| Text2 | TextBox | 出力 | String | カウント表示（Locked=True） |

## 表示項目

| 項目名 | コントロール | データ型 | 説明 |
|--------|-------------|----------|------|
| Label1 | Label | String | "Delay:" ラベル |
| Label2 | Label | String | "Count:" ラベル |
| Text2 | TextBox | String | 現在のカウント値 |

## イベント仕様

### 1-Form_Load

フォーム読み込み時にTickerとCounterオブジェクトを初期化します。

**処理内容**:
1. Counterオブジェクトを作成（New Counter）
2. NewTicker関数でTickerオブジェクトを作成（インターバル100ms、Counterオブジェクト、AddressOf TickerCallbackを渡す）

**コード参照**: 行114-124

```vb
Private Sub Form_Load()
    Set mCounter = New Counter

    ' Create a new Ticker easily. We pass in the object we want
    ' the Ticker to be able to deal will without having to set
    ' some global variable that the Ticker can reach.
    '
    ' We also pass in the address of our callback function that
    ' will handle the elapsed time event.
    Set mTicker = NewTicker(100, mCounter, , AddressOf TickerCallback)
End Sub
```

### 2-cmdStartTicker_Click

タイマーを開始します。

**処理内容**:
1. Text1の値をTickerのIntervalに設定
2. Tickerが停止中であればStartTickerを呼び出し

**コード参照**: 行95-108

### 3-cmdStopTicker_Click

タイマーを停止します。

**処理内容**:
1. mTicker.StopTickerを呼び出してタイマー停止

**コード参照**: 行110-112

### 4-cmdResetCount_Click

カウンターをリセットします。

**処理内容**:
1. mCounter.Countを0に設定

**コード参照**: 行91-93

### 5-TickerCallback（モジュールレベル関数）

Tickerのコールバック関数。インターバルごとに呼び出されます。

**処理内容**:
1. 引数DataからCounterオブジェクトを取得
2. Counter.Countを1加算

**注意**: この関数はフォームモジュールではなく、標準モジュール（.bas）に定義されている必要があります。

### 6-mCounter_Changed

Counterオブジェクトのイベントハンドラ。Count変更時に呼び出されます。

**処理内容**:
1. Text2にカウント値を表示

**コード参照**: 行126-128

## データベース更新仕様

本画面はデータベースを使用しません。

## メッセージ仕様

本画面にメッセージ表示機能はありません。

## 例外処理

| 例外種別 | 対処方法 |
|---------|---------|
| 無効なインターバル値 | 数値以外の入力時はVBランタイムエラー発生 |
| コールバック関数未定義 | AddressOf指定時にコンパイルエラー |

## 備考

- BorderStyle = Fixed Single（サイズ変更不可）
- MaxButton = False, MinButton = False（最大化・最小化ボタン無効）
- Event版との違い：mTicker_Elapsedイベントハンドラがない
- AddressOf演算子で標準モジュールの関数アドレスを渡す
- CounterオブジェクトはWithEventsで宣言（Counter.Changedイベントを受信）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Event版との違いを中心に、変数宣言を理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Form1.frm | `Examples/Misc/SimpleTicker2/Form1.frm` | 行79-83: コメント説明（Callback版の特徴） |
| 1-2 | Form1.frm | `Examples/Misc/SimpleTicker2/Form1.frm` | 行86-89: 変数宣言 |

**読解のコツ**: Event版と比較して、mTickerにWithEventsキーワードが**ない**ことに注目してください。これがCallback版の特徴です。

```vb
' We aren't gonna listen for an Event from the Ticker.
Private mTicker As Ticker

Private WithEvents mCounter As Counter
```

#### Step 2: エントリーポイントを理解する

フォーム読み込み時の初期化処理がエントリーポイントです。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Form1.frm | `Examples/Misc/SimpleTicker2/Form1.frm` | 行114-124: Form_Load |

**主要処理フロー**:
1. **行115**: Counter オブジェクトを生成
2. **行123**: NewTicker関数でTickerオブジェクトを生成
   - 第1引数: インターバル100ms
   - 第2引数: Counterオブジェクト（Data）
   - 第4引数: AddressOf TickerCallback（コールバック関数アドレス）

#### Step 3: Event版との比較を理解する

Event版との違いを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Form1.frm | `Examples/Misc/SimpleTicker2/Form1.frm` | 行130-132: コメント「We have not mTicker_Elapsed event to handle」 |

**Event版との違い**:
- Event版: `Private WithEvents mTicker As Ticker` + `mTicker_Elapsed`ハンドラ
- Callback版: `Private mTicker As Ticker` + `AddressOf TickerCallback`

### プログラム呼び出し階層図

```
Form_Load
    │
    ├─ New Counter
    │
    └─ NewTicker(100, mCounter, , AddressOf TickerCallback)
           │
           └─ 内部でTickerCallback関数アドレスを保持

cmdStartTicker_Click
    │
    ├─ mTicker.Interval = Text1.Text
    │
    └─ mTicker.StartTicker

cmdStopTicker_Click
    │
    └─ mTicker.StopTicker

cmdResetCount_Click
    │
    └─ mCounter.Count = 0
           │
           └─ [イベント発火] mCounter_Changed
                  │
                  └─ Text2.Text = mCounter.Count

[タイマー発火]
    │
    └─ TickerCallback(Data As Variant) ← 標準モジュールの関数
           │
           └─ Data.Count = Data.Count + 1 (Counterオブジェクト操作)
                  │
                  └─ [イベント発火] mCounter_Changed
                         │
                         └─ Text2.Text = mCounter.Count
```

### データフロー図

```
[入力]               [処理]                    [出力]

Text1 (Delay) ───▶ mTicker.Interval ─────────▶ タイマー設定

NewTicker ────────▶ AddressOf TickerCallback
                          │
                          ▼
                    [タイマー発火]
                          │
                          ▼
                    TickerCallback(Data)
                    [標準モジュール]
                          │
                          ▼
                    mCounter.Count++
                          │
                          ▼
                    mCounter_Changed
                          │
                          ▼
                    Text2.Text ──────────────▶ カウント表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Form1.frm | `Examples/Misc/SimpleTicker2/Form1.frm` | ソース | メインフォーム |
| Counter.cls | `Examples/Misc/SimpleTicker2/Counter.cls` | ソース | カウンタークラス |
| Module1.bas | `Examples/Misc/SimpleTicker2/Module1.bas` | ソース | TickerCallback関数定義 |
| SimpleTicker2.vbp | `Examples/Misc/SimpleTicker2/SimpleTicker2.vbp` | プロジェクト | プロジェクト定義 |
| VBCorLib.dll | 外部 | DLL | VBCorLibライブラリ本体（Ticker提供） |
